<?php
// SociWise Dijital Pazarlama Ajansı | sociwise.com | iletisim@sociwise.com
// SociWise tarafından PHPMailer kullanımı için hazırlanmış örnek koddur. Değiştirmeniz gereken yerler videoda ve yorum satırlarında belirtilmiştir.
// Dilediğiniz gibi kullanabilirsiniz.


// Gerekli kütüphaneleri yükle
require 'vendor/autoload.php';

// Kullanılacak sınıfları tanımla
use PhpOffice\PhpSpreadsheet\IOFactory;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

try {
    // Excel dosyasını oku
    $excel = IOFactory::load('liste.xlsx'); 
    $sayfa = $excel->getActiveSheet();
    $musteriler = [];

    // Excel dosyasındaki her satırı döngüye al
    foreach ($sayfa->getRowIterator() as $satir) {
        $hucre_iterator = $satir->getCellIterator();
        $hucre_iterator->setIterateOnlyExistingCells(false);
        $satir_veri = [];
        // Her hücredeki veriyi oku
        foreach ($hucre_iterator as $hucre) {
            $satir_veri[] = $hucre->getValue();
        }
        $musteriler[] = $satir_veri;
    }

    // E-posta gönderimi için PHPMailer'ı ayarla
    $posta = new PHPMailer(true);
    $posta->isSMTP();
    $posta->Host       = 'smtp.ornek.com';
    $posta->SMTPAuth   = true;
    $posta->Username   = 'ornek@eposta.com';
    $posta->Password   = 'sifreniz';
    $posta->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // SSL için geçerlidir, TLS için değitirmeniz gerekir.
    $posta->Port       = 465;
    $posta->CharSet = 'UTF-8';
    $posta->setFrom('ornek@eposta.com', 'SociWise Dijital Pazarlama Ajansı');

    // Her müşteri için e-posta gönder
    foreach ($musteriler as $musteri) {
        $eposta = $musteri[0];
        $isim = $musteri[1];

        // E-posta alıcısını, konusunu ve içeriğini ayarla
        $posta->addAddress($eposta, $isim);
        $posta->isHTML(true);
        $posta->Subject = 'Özel Teklif';
        $posta->Body    = "<!DOCTYPE html>
        <html lang='tr'>
        <head>
            <meta charset='UTF-8'>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    line-height: 1.6;
                    color: #333;
                    max-width: 600px;
                    margin: 0 auto;
                    padding: 20px;
                }
                .header {
                    background-color: #4a90e2;
                    color: white;
                    padding: 20px;
                    text-align: center;
                }
                .content {
                    background-color: #f9f9f9;
                    border: 1px solid #ddd;
                    padding: 20px;
                    margin-top: 20px;
                }
                .button {
                    display: inline-block;
                    background-color: #4CAF50;
                    color: white;
                    padding: 10px 20px;
                    text-decoration: none;
                    border-radius: 5px;
                    margin-top: 20px;
                }
                .footer {
                    margin-top: 20px;
                    text-align: center;
                    font-size: 0.8em;
                    color: #666;
                }
            </style>
        </head>
        <body>
            <div class='header'>
                <h1>SociWise Dijital Pazarlama Ajansı</h1>
            </div>
            <div class='content'>
                <h2>Sayın $isim,</h2>
                <p>Sizin için özel olarak hazırladığımız teklifimizi incelemenizi rica ediyoruz.</p>
                <p>Bu teklifimizde dijital pazarlama stratejilerinizi güçlendirecek özel fırsatlar bulacaksınız.</p>
                <a href='https://www.sociwise.com/ozel-teklif' class='button'>Özel Teklifinizi İnceleyin</a>
            </div>
            <div class='footer'>
                <p>Bu e-posta SociWise Dijital Pazarlama Ajansı tarafından gönderilmiştir.</p>
                <p>Adres: Örnek Mahallesi, Örnek Sokak No:123, İstanbul</p>
            </div>
        </body>
        </html>";
        
        // E-postayı gönder
        $posta->send();
        
        // Bir sonraki gönderim için alıcı adresini temizle
        $posta->clearAddresses();
    }

    // İşlem başarılı mesajını göster
    echo 'E-postalar başarıyla gönderildi';

} catch (Exception $e) {
    // E-posta gönderim hatası durumunda hata mesajını göster
    echo "E-posta gönderimi başarısız: {$posta->ErrorInfo}";
} catch (\PhpOffice\PhpSpreadsheet\Reader\Exception $e) {
    // Excel dosyası okuma hatası durumunda hata mesajını göster
    echo "Excel dosyası okuma hatası: {$e->getMessage()}";
}